//a simple example of how to do a vertically scrolling game
//for use with gamex.lib, created in Turbo C++
#include "alloc.h"
#include "grlibv2.h"

void main()
{
  int a,x=160,y=100,dir=1,mode;
  unsigned char *bptr=(unsigned char *)malloc(37*37+2);
  char c;

  InitGameBuff(320,800);//make game buffer 4 VGA screens tall

  //give choice of VGA or SVGA
  printf("\nPress 1 for VGA or 2 for SVGA");
  c=getch();
  if (c=='1') mode=0; else mode=1;

  InitKeyScan();//start up key press scanning

  //check for vesa compatibility
  if (mode==1&&ChkVesa(1)==0) Quit("");
  //set screen mode
  if (mode==0) SetVGA();
  else SetSVGA();

  //load in the pictures
  if (LoadPic1("back.pcx",0)==0) Quit("Pcx not found");
  if (LoadMBM("sph.mbm",1)==0) Quit("mbm not found");

  //cover game buffer with backdrop image
  PutPic(0,0,0);
  PutPic(0,0,200);
  PutPic(0,0,400);
  PutPic(0,0,600);

  //save backdrop area under foreground sphere
  CutOut(x-18,y-18,37,37,bptr);
  //put foreground sphere
  PutMBM(1,x-18,y-18);

  a=0;

  //main loop
  do
  {
    //replace saved backdrop area over foreground sphere
    PutBitmap(x-18,y-18,bptr);

    //do movement left/right if relevant key pressed
    if (CheckKey(77)==1&&x<300) x+=2;
    if (CheckKey(75)==1&&x>18) x-=2;

    //move sphere in y dimension
    if (dir==1) y+=2; else y-=2;
    if (y>700) {y=700; dir=0;}
    else if (y<100) {y=100; dir=1;}

    //save new backdrop area under foreground sphere
    CutOut(x-18,y-18,37,37,bptr);
    //put foreground sphere
    PutMBM(1,x-18,y-18);

    //display window on buffer, to the screen
    DWinBuffer(0,y-100,0,0,320,200);

    a++;
  }
  while(CheckKey(1)!=1&&a<2000); //while escape key not pressed

  //close down
  FreeMem();
  SetTXT();
  CloseKeyScan();
}